/*
  Select Related Layers
    あかつきみさき

  このスクリプトについて
    最後に選択したレイヤーが親レイヤーの場合はその子レイヤーを,子レイヤーの場合はその親レイヤーを選択するスクリプト.
    対象のレイヤーが親子両方の関係を持っている場合は子レイヤーの選択を優先します.

  使用方法
    ファイル→スクリプト→スクリプトファイルの実行から実行.

  動作保障環境
    Adobe After Effects 2024以上

  バージョン情報
    2026/01/03 Ver 1.0.0 Release
*/

(function () {
    var data = {
        scriptName: "Select Related Layers",
        scriptVersion: "1.0.0",
    }

    var actComp = app.project.activeItem;
    if (!(actComp instanceof CompItem)) {
        return 0;
    }

    var selLayers = actComp.selectedLayers;
    if (selLayers.length == 0) {
        return 0;
    }
    var selLayer = selLayers[selLayers.length - 1];

    var relatedLayers = [];
    var writeLog = "";
    // まず子レイヤーがあるか確認し、あれば子レイヤー選択を優先
    for (var i = 1; i <= actComp.numLayers; i++) {
        var layer = actComp.layer(i);
        if (layer.parent == selLayer) {
            relatedLayers[relatedLayers.length] = layer;
        }
    }
    if (relatedLayers.length > 0) {
        writeLog = "「" + selLayer.name + "」の子レイヤーを" + relatedLayers.length + "個選択";
    } else if (selLayer.parent != null) {
        // 子レイヤーを選択している場合、その親レイヤーを選択
        relatedLayers = [selLayer.parent];
        writeLog = "「" + selLayer.name + "」の親レイヤー「" + selLayer.parent.name + "」を選択";
    }

    if (relatedLayers.length > 0) {
        app.beginUndoGroup(writeLog + " - " + data.scriptName);
        for (var i = 1; i <= actComp.numLayers; i++) {
            actComp.layer(i).selected = false;
        }

        for (var j = 0; j < relatedLayers.length; j++) {
            relatedLayers[j].selected = true;
        }

        writeLn(writeLog);
        app.endUndoGroup();
    }


    return 0;
}).call(this);